implementation module Help

import StdInt, StdBool, StdList, StdTuple, StdArray, StdMisc
import StdId, StdPicture, StdPSt, StdWindow, StdSystem

::	InfoDef		:== (Size,[InfoLine])
::	InfoLine	:== (InfoFontDef,Int,Int,String)
::	InfoFontDef	=	InfoFont Font Centred
				|	NoFont	 Centred
::	Centred		:== Bool
::	Fonts
	=	{	normal		:: Font
		,	large		:: Font
		,	bold		:: Font
		,	large_bold	:: Font
		}
::	Heights		:== (Int,Int)

InfoFontName1	:== SansSerifFontDef.fName
InfoFontName2	:== SerifFontDef.fName
NormalSize1		:== 9
NormalSize2		:== 12
LargeSize1		:== 12
LargeSize2		:== 14
Margin			:== 8
AboutBegin		:== "\\About"
AboutEnd		:== "\\EndAbout"
HelpBegin		:== "\\Help"
HelpEnd			:== "\\EndHelp"
About			:== False
Help			:== True


// sfopen for use with accFiles
sfopen2 fileName mode files
	:==	((ok, file), files2)
	where
		(ok, file, files2)
			=	sfopen fileName mode files

/*	showAbout opens a window:
	-	it has the title of the application name (String argument 1),
	-	it displays the about information of the application (found in the helpfile, name argument 2),
	-	it has an Ok button that closes this window, 
	-	it has a Help button that displays the help information (see showHelp).
*/
showAbout :: String String (PSt .l .p) -> PSt .l .p
showAbout appname helpfile pState
	#	(okId, pState)		= accPIO openId pState
	#	(fonts,pState)		= infoFonts pState
		{normal}			= fonts
	#	((size,text),pState)= readInfo About fonts AboutBegin AboutEnd helpfile pState
		about				= Dialog ("About "+++appname)
	  							(	CustomControl size (look normal text)	[ ControlPos		(Center,zero)]
	  							:+:	ButtonControl "Ok"						[ ControlId			okId
	  																		, ControlFunction	(noLS closeActiveWindow)
	  																		, ControlPos		(Center,zero)
	  																		]
	  							:+:	ButtonControl "Help"					[ ControlFunction	(noLS (showHelp helpfile))]
	  							)
	  							[	WindowOk okId	]
	=	snd (openDialog undef about pState)


/*	showHelp opens a resizeable window that displays the help information found in the helpfile.
*/
showHelp :: String (PSt .l .p) -> PSt .l .p
showHelp helpfile pState
	#	pState				= closeActiveWindow pState
	#	(fonts,pState)		= infoFonts pState
	#	((size,text),pState)= readInfo Help fonts HelpBegin HelpEnd helpfile pState
		window				= Window "Help" 
	  							NilLS
	  							[	WindowSize		size
	  							,	WindowLook		(look fonts.normal text)
	  							,	WindowResize
	  							,	WindowHScroll	hscroll
	  							,	WindowVScroll	vscroll
	  							,	WindowClose		(noLS closeActiveWindow)
	  							]
	=	snd (openWindow undef window pState)
where
	hscroll curViewFrame {sliderThumb} move
		= case move of
			SliderIncSmall -> sliderThumb+10
			SliderDecSmall -> sliderThumb-10
			SliderIncLarge -> sliderThumb+(rectangleSize curViewFrame).w*4/5
			SliderDecLarge -> sliderThumb-(rectangleSize curViewFrame).w*4/5
			SliderThumb x  -> x
				
	vscroll curViewFrame {sliderThumb} move
		= case move of
			SliderIncSmall -> sliderThumb+10
			SliderDecSmall -> sliderThumb-10
			SliderIncLarge -> sliderThumb+(rectangleSize curViewFrame).h*4/5
			SliderDecLarge -> sliderThumb-(rectangleSize curViewFrame).h*4/5
			SliderThumb x  -> x

look :: Font [InfoLine] SelectState UpdateState -> *Picture -> *Picture
look font lines _ {updArea}
	=	seq (	[	setPenColour White : map fill updArea ]
				++
				[	setPenColour Black, setPenFont font 
				:	map (\{corner1,corner2} -> drawInfo font (corner1.y-1) (corner2.y+40) lines) updArea
				])

closeActiveWindow :: (PSt .l .p) -> PSt .l .p
closeActiveWindow pState
	#	(maybe_id,pState)	= accPIO getActiveWindow pState
	|	isNothing maybe_id
		=	pState
		=	closeWindow (fromJust maybe_id) pState


//	Try to open a prefered set of fonts to display the help and about information:

infoFonts :: (PSt .l .p) -> (Fonts,PSt .l .p)
infoFonts pState
	#	(normal,    pState)	= selectfont [(InfoFontName1,NormalSize1),(InfoFontName2,NormalSize2)] [] pState
	#	(large,     pState)	= selectfont [(InfoFontName1,LargeSize1 ),(InfoFontName2,LargeSize2 )] [] pState
	#	(bold,      pState)	= selectfont [(InfoFontName1,NormalSize1),(InfoFontName2,NormalSize2)] [BoldStyle] pState
	#	(large_bold,pState)	= selectfont [(InfoFontName1,LargeSize1 ),(InfoFontName2,LargeSize2 )] [BoldStyle] pState
	=	({normal=normal,large=large,bold=bold,large_bold=large_bold},pState)
where
	selectfont :: ![(String,Int)] ![FontStyle] (PSt .l .p) -> (Font,PSt .l .p)
	selectfont [(fontname,size):preffonts] style pState
		# ((found,font),pState)	= accPIO (accScreenPicture (openFont {fName=fontname,fStyles=style,fSize=size}))
										 pState
		| found
			= (font,pState)
		| otherwise
			= selectfont preffonts style pState
	selectfont _ style pState
		= accPIO (accScreenPicture openDefaultFont) pState


//	Determine the line height and leading of a given font:

getFontHeightAndAscent :: Fonts (PSt .l .p) -> (((Int,Int),(Int,Int)),PSt .l .p)
getFontHeightAndAscent {normal,large} pState=:{io}
	#	(normal,io)	= accScreenPicture (getFontMetrics normal) io
	#	(large, io)	= accScreenPicture (getFontMetrics large)  io
	=	(((fontLineHeight normal,normal.fAscent), (fontLineHeight large,large.fAscent)),{ pState & io=io })


//	Reading and pre-processing of the file containing the about- and help-info. */

readInfo :: Bool Fonts String String String (PSt .l .p) -> ((Size,[InfoLine]),PSt .l .p)
readInfo help fonts begin end filename pState
	#	(metrics,      pState)	= getFontHeightAndAscent fonts pState
	#	((succes,file),pState)	= accFiles (sfopen2 (applicationpath filename) FReadText) pState
	|	not succes && help
		=	processInfoStrings fonts metrics [errpref+++"could not be found."] pState
	|	not succes
		=	processInfoStrings fonts metrics ["\\DThis is a Clean program."] pState
	#	(found,info)				= readInfoFile begin end file
	|	not found && help
		=	processInfoStrings fonts metrics [errpref+++"does not contain help information."] pState
	|	not found
		=	processInfoStrings fonts metrics ["\\DThis is a Clean program."] pState
	|	otherwise
		=	processInfoStrings fonts metrics info pState
where
	errpref						= "The help file \'"+++filename+++"\' " 
	
	processInfoStrings :: Fonts ((Int,Int),(Int,Int)) [String] (PSt .l .p) -> (InfoDef,PSt .l .p)
	processInfoStrings fonts ((normalHeight,normalAscent),(largeHeight,largeAscent)) lines pState
		#	((size,lines),pState)	= addFontToInfoLines fonts (normalHeight,largeHeight) 0 (Margin+largeAscent) lines pState
			width					= Margin+size.w+Margin
		#	(lines,pState)			= seqList (map (centerInfoLine fonts.normal width) lines) pState
		=	(({w=width,h=size.h+Margin-largeAscent},lines),pState)
	where
		addFontToInfoLines :: Fonts Heights Int Int [String] (PSt .l .p) -> (InfoDef,PSt .l .p)
		addFontToInfoLines fonts heights maxx maxy [line:rest] pState
			#	((font,wid,hgt,line),pState)	= parseInfoLine fonts heights line pState
			#	((size,rest),        pState)	= addFontToInfoLines fonts heights (max maxx wid) (maxy+hgt) rest pState
			=	((size,[(font,Margin,maxy,line):rest]),pState)
		where
		//	parseInfoLine determines the font that should be used to draw the line.
		//	If line == '\{L,b,B,c,C,d,D}'+++line1 then a special font is used, otherwise the default font is used.
		//	parseInfoLine also calculates the width and height of the line.
		
			parseInfoLine :: Fonts Heights String (PSt .l .p) -> ((InfoFontDef,Int,Int,String),PSt .l .p)
			parseInfoLine fonts=:{normal,large,bold,large_bold} heights=:(nhgt,lhgt) line pState
				#	linelen	= size line
				|	linelen<2 || line.[0]<>'\\'
					#	(width,pState)	= accPIO (accScreenPicture (getFontStringWidth normal line)) pState
					=	((NoFont False,width,nhgt,line),pState)
				| otherwise
					#	(infofont,font,height)	= case (line.[1]) of
													'L' -> (InfoFont large      False, large,      lhgt)
													'b' -> (InfoFont bold       False, bold,       nhgt)
													'B' -> (InfoFont large_bold False, large_bold, lhgt)
													'c' -> (NoFont   True,             normal,     nhgt)
													'C' -> (InfoFont large      True , large,      lhgt)
													'd' -> (InfoFont bold       True , bold,       nhgt)
													'D' -> (InfoFont large_bold True , large_bold, lhgt)
													_   -> (NoFont   False,            normal,     nhgt)
						line					= line%(2,linelen-1)
					#	(width,pState)			= accPIO (accScreenPicture (getFontStringWidth font line))
														 pState
					=	((infofont,width,height,line),pState)
		addFontToInfoLines _ _ maxx maxy _ pState
			=	(({w=maxx,h=maxy},[]),pState)
		
		centerInfoLine :: Font Int InfoLine (PSt .l .p) -> (InfoLine,PSt .l .p)
		centerInfoLine nft maxx info=:(inft=:NoFont centered,x,y,line) pState
			|	not centered
				=	(info,pState)
			|	otherwise
				#	(width,pState)	= accPIO (accScreenPicture (getFontStringWidth nft line)) pState
				=	((inft,(maxx-width)/2,y,line),pState)
		centerInfoLine nft maxx info=:(inft=:InfoFont font centered,x,y,line) pState
			|	not centered
				=	(info,pState)
			|	otherwise
				#	(width,pState)	= accPIO (accScreenPicture (getFontStringWidth font line)) pState
				=	((inft,(maxx-width)/2,y,line),pState)
	
	readInfoFile :: String String File -> (Bool,[String])
	readInfoFile begin end file
		#	(begin_found,file)	= findInfoBegin begin file
		|	not begin_found
			=	(False,[])
		|	otherwise
			#	(lines,_)		= readInfoUntil end file
			=	(True,lines)
	where
		findInfoBegin :: String File -> (Bool,File)
		findInfoBegin begin file
			|	sfend file
				=	(False,file)
			#	(line,file)	= sfreadline file
			|	isPrefixOf begin line
				=	(True,file)
			|	otherwise
				=	findInfoBegin begin file
		
		readInfoUntil :: String File -> ([String],File)
		readInfoUntil end file
			|	sfend file
				=	([],file)
			#	(line,file)		= sfreadline file
			|	isPrefixOf end line
				=	([],file)
			|	otherwise
				#	(lines,file)= readInfoUntil end file
				=	([stripNewline line:lines],file)
		where
			stripNewline :: String -> String
			stripNewline string
				|	string==""
					=	string
				|	string.[last]<>'\n'
					=	string
				|	otherwise
					=	string%(0,last-1)
			where
				last= size string-1
		
		isPrefixOf :: String String -> Bool
		isPrefixOf prefix string
			|	prefixlen>size string
				=	False
			|	otherwise
				=	prefix==string%(0,prefixlen-1) 
		where
			prefixlen	= size prefix


/*	The drawing of the about/help info. */

drawInfo :: Font Int Int [InfoLine] *Picture -> *Picture
drawInfo defaultfont top bot [(InfoFont font c,x,y,line):rest] pic
	|	y>bot
		=	pic
	|	y<top
		=	drawInfo defaultfont top bot rest pic
	|	otherwise
		#	pic	= setPenFont font pic
		#	pic	= drawAt {x=x,y=y} line pic
		#	pic	= setPenFont defaultfont pic
		=	drawInfo defaultfont top bot rest pic
drawInfo defaultfont top bot [(NoFont c,x,y,line):rest] pic
	|	y>bot
		=	pic
	|	y<top
		=	drawInfo defaultfont top bot rest pic
	|	otherwise
		=	drawInfo defaultfont top bot rest (drawAt {x=x,y=y} line pic)
drawInfo _ _ _ _ pic
	=	pic
